/*----------------------------------------------------------------------
 | CONST.H                                                      940420
 |
 | Contains all constant definitions.
 +----------------------------------------------------------------------*/


#undef Debug
#include "compiler.def"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <math.h>
#ifdef Gcc
#include <sys/timeb.h>
#include <sys/times.h>          /* Needed for calculating CPU-time */
#include <sys/types.h>          /* Needed for calculating CPU-time */
#include <sys/param.h>          /* Needed for the definition of HZ */
#else
#include <sys\timeb.h>
#endif


/*

   b0   b1 b2 b3 b4 b5 b6 b7 b8   b9 ba bb bc bd be bf
   a0   a1 a2 a3 a4 a5 a6 a7 a8   a9 aa ab ac ad ae af
   +-------------------------+
   90 | A8 B8 C8 D8 E8 F8 G8 H8 | 99 9a 9b 9c 9d 9e 9f
   80 | A7 B7 C7 D7 E7 F7 G7 H7 | 89 8a 8b 8c 8d 8e 8f
   70 | A6 B6 C6 D6 E6 F6 G6 H6 | 79 7a 7b 7c 7d 7e 7f
   60 | A5 B5 C5 D5 E5 F5 G5 H5 | 69 6a 6b 6c 6d 6e 6f
   50 | A4 B4 C4 D4 E4 F4 G4 H4 | 59 5a 5b 5c 5d 5e 5f
   40 | A3 B3 C3 D3 E3 F3 G3 H3 | 49 4a 4b 4c 4d 4e 4f
   30 | A2 B2 C2 D2 E2 F2 G2 H2 | 39 3a 3b 3c 3d 3e 3f
   20 | A1 B1 C1 D1 E1 F1 G1 H1 | 29 2a 2b 2c 2d 2e 2f
   +-------------------------+
   10   11 12 13 14 15 16 17 18   19 1a 1b 1c 1d 1e 1f
   00   01 02 03 04 05 06 07 08   09 0a 0b 0c 0d 0e 0f
 */

#define BoardLength     16      /* Power of 2 because of dividing by Length */
#define NrSquares       (BoardLength*12)

/* Squares */
#define A1      (2*BoardLength+1)
#define B1      (A1+1)
#define C1      (B1+1)
#define D1      (C1+1)
#define E1      (D1+1)
#define F1      (E1+1)
#define G1      (F1+1)
#define H1      (G1+1)
#define A2      (A1+BoardLength)
#define B2      (A2+1)
#define C2      (B2+1)
#define D2      (C2+1)
#define E2      (D2+1)
#define F2      (E2+1)
#define G2      (F2+1)
#define H2      (G2+1)
#define A3      (A2+BoardLength)
#define B3      (A3+1)
#define C3      (B3+1)
#define D3      (C3+1)
#define E3      (D3+1)
#define F3      (E3+1)
#define G3      (F3+1)
#define H3      (G3+1)
#define A4      (A3+BoardLength)
#define B4      (A4+1)
#define C4      (B4+1)
#define D4      (C4+1)
#define E4      (D4+1)
#define F4      (E4+1)
#define G4      (F4+1)
#define H4      (G4+1)
#define A5      (A4+BoardLength)
#define B5      (A5+1)
#define C5      (B5+1)
#define D5      (C5+1)
#define E5      (D5+1)
#define F5      (E5+1)
#define G5      (F5+1)
#define H5      (G5+1)
#define A6      (A5+BoardLength)
#define B6      (A6+1)
#define C6      (B6+1)
#define D6      (C6+1)
#define E6      (D6+1)
#define F6      (E6+1)
#define G6      (F6+1)
#define H6      (G6+1)
#define A7      (A6+BoardLength)
#define B7      (A7+1)
#define C7      (B7+1)
#define D7      (C7+1)
#define E7      (D7+1)
#define F7      (E7+1)
#define G7      (F7+1)
#define H7      (G7+1)
#define A8      (A7+BoardLength)
#define B8      (A8+1)
#define C8      (B8+1)
#define D8      (C8+1)
#define E8      (D8+1)
#define F8      (E8+1)
#define G8      (F8+1)
#define H8      (G8+1)

/* Files */
#define A       1
#define B       2
#define C       3
#define D       4
#define E       5
#define F       6
#define G       7
#define H       8

/* Contents of squares */
#define Empty   0

#define Black   0
#define White   1

#define Pawn    2
#define Knight  4
#define Bishop  8
#define Rook    16
#define Queen   32
#define King    64

#define Edge    128

#define WhitePawn   (White | Pawn)
#define WhiteKnight (White | Knight)
#define WhiteBishop (White | Bishop)
#define WhiteRook   (White | Rook)
#define WhiteQueen  (White | Queen)
#define WhiteKing   (White | King)

#define BlackPawn   (Black | Pawn)
#define BlackKnight (Black | Knight)
#define BlackBishop (Black | Bishop)
#define BlackRook   (Black | Rook)
#define BlackQueen  (Black | Queen)
#define BlackKing   (Black | King)

#define MaxKnightMoves  8
#define MaxBishopMoves  13
#define MaxRookMoves    14

#define MaxMoves        200     /* Maximum number of moves in a position */

#define True    1
#define False   0

#define Up      BoardLength
#define Down    (-BoardLength)
#define Right   1
#define Left    (-1)

/* Move types */
#define Normal          0
#define Double          1
#define ShortCastle     2
#define LongCastle      4
#define EnPassant       8
#define Capture         16
#define Promotion       32

#define NoEp            1       /* Not 0 because of 0s in move tables */

#define MaxCommandLength        256

#define Ever    ;;

/* Commands */
#define Quit            0
#define Help            1
#define Move            2
#define PrintB          3
#define List            4
#define Forward         5
#define Back            6
#define NewG            7
#define PrintG          8
#define Compute         9
#define Save            10
#define Load            11
#define Clear           12
#define Place           13
#define Remove          14
#define SavePos         15
#define Test            16
#define MaxCommands     17

#define MaxGamePlies    1000
#define MaxSearchDepth  30

#define MaxMoveLength           8
#define MaxFileNameLength       80

/* Possible castlings */
#define WhiteShort      1
#define WhiteLong       2
#define BlackShort      4
#define BlackLong       8

/* Castle indices used for castlingHashTable */
#define Short           0
#define Long            1

#ifdef Gcc
#define GameDirectory   "games/"
#else
#define GameDirectory   "games\\"
#endif

/* Evaluation values */
#define Mate            10000
#define Draw            0
#define Infinity        16000
#define MateValue       (Mate-100)

/* Test defaults */
#define DepthDefault            5
#define ColorDefault            White
#define TransTableDefault       0
#define RefTableDefault         1
#define TwoLevelTableDefault    1
#define TtValueDefault          1
#define TtMoveDefault           1
#define TimeStampDefault        1
#define UseFlagDefault          0
#define TtBitsDefault           19

#define EndgameMaterial 5000    /* 1800+3200 */

/* flag for transposition table */
#define NoEntry         0
#define Valid           1
#define UpperBound      2
#define LowerBound      3

/* Keep methods in case of collision */
#define New             0
#define Old             1
#define Deep            2
#define Big1            3
#define BigAll          4

/* Pack constants for transposition tables */
#define PackKnight      0
#define PackBishop      1
#define PackRook        2
#define PackQueen       3

#define PackNormal              0
#define PackDouble              1
#define PackShortCastle         2
#define PackLongCastle          3
#define PackEnPassant           4
#define PackCapture             5
#define PackPromotion           6
#define PackCapPromotion        7

#define StartPositionHash       ((0x34L<<24) | (0x17L<<16) | (0xa3L<<8) | 0xe6L)
